clear all, close all

% general directory
folder = 'D:\Dropbox\Desalination\Figures for the manuscript\Data for IV-plots\Chronoamperometry\Measurements 1\Chip14_1mMNaCl_5uMAlexa_3uLmin_70V_samples5';

[U,I,t] = read_data_keithley(folder,0);

% plot figure
nn = 0;
map = cbrewer('seq','OrRdBlGr',3);

% plot values on log-lin scale
nn = nn+1;
figure(nn)
hold on
plot(t,1e6.*I,'-','Color',map(1,:))
hold off
box on
xlabel('t (s)')
ylabel('I (\muA)')
title('(a) 1 mM NaCl, 3 \muL/min, \DeltaU = 70V')
% ylim([1e-3 1e1])
% xlim([0 max(t)])
xlim([0 1500])
set(gca,'XTick',0:250:1500)
% legend([H(1).mainLine,H(2).mainLine,H(3).mainLine],legendentries,'Location','SouthEast')
% legend boxoff
% set(gca,'yScale','log')
set(gcf,'color','w');
fig=gcf;
% set(findall(fig,'-property','FontSize'),'FontSize',13) 
% export_fig Itcurve_chip14.png -m3
matlab2tikz('Itcurve_chip14.tikz', 'height', '\figureheight', 'width', '\figurewidth');
